/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.licence;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.PanelHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

class LicenceLoader {
    private static final String DEFAULT_SUFFIX = ".licence";
    private final Panel panel;
    private final Class<?> panelClass;
    private final Resources resources;

    LicenceLoader(Class<?> panelClass, Panel panel, Resources resources) {
        this.panel = panel;
        this.panelClass = panelClass;
        this.resources = resources;
    }

    URL asURL() throws ResourceException {
        Class<?> targetClass = LicenceLoader.findTargetClass(this.panelClass);
        String resourceNamePrefix = targetClass.getSimpleName();
        String defaultResourceName = resourceNamePrefix + DEFAULT_SUFFIX;
        String specificResourceName = LicenceLoader.buildSpecificResourceName(resourceNamePrefix, this.panel);
        try {
            if (null != specificResourceName) {
                return this.resources.getURL(specificResourceName);
            }
        }
        catch (ResourceNotFoundException ignored) {
            // empty catch block
        }
        try {
            return this.resources.getURL(defaultResourceName);
        }
        catch (ResourceNotFoundException ignored) {
            String message = LicenceLoader.buildFinalErrorMessage(resourceNamePrefix, defaultResourceName, specificResourceName);
            throw new ResourceNotFoundException(message);
        }
    }

    String asString() throws ResourceException {
        return this.asString("UTF-8");
    }

    String asString(String encoding) throws ResourceException {
        URL url = this.asURL();
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IOUtils.toString(in, Charsets.toCharset(encoding));
            return string;
        }
        catch (IOException e) {
            throw new ResourceNotFoundException("Cannot convert license document from resource " + url.getFile() + " to text: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    static Class<?> findTargetClass(Class<?> panelClass) throws ResourceException {
        Class<IzPanel> targetClass = PanelHelper.getIzPanel(panelClass.getName());
        if (null == targetClass) {
            throw new ResourceNotFoundException("No IzPanel implementation found for " + panelClass.getSimpleName());
        }
        return targetClass;
    }

    static String buildSpecificResourceName(String resourceNamePrefix, Panel panel) {
        if (null != panel && panel.hasPanelId()) {
            return resourceNamePrefix + '.' + panel.getPanelId();
        }
        return null;
    }

    static String buildFinalErrorMessage(String panelType, String ... resourceNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot open any of the possible license document resources (");
        boolean isFirst = true;
        for (String resourceName : resourceNames) {
            if (null == resourceName) continue;
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(resourceName);
            if (!isFirst) continue;
            isFirst = false;
        }
        sb.append(") for panel type '");
        sb.append(panelType);
        sb.append("'");
        return sb.toString();
    }
}

